function [unspecificNucleotides , sumOfUnspNucleotides] = CountUnspecificNucleotides(sequence)
%{
description:
The in silico digestion uses regexpi() to find the restriction recognition
site (RRS) (AGCT for AluI). Since, regexpi() matches the RRS by ignoring
umbiguities, sequences with ambiguities might be incomplitely digested.

R	A or G
Y	C or T
S	G or C
W	A or T
K	G or T
M	A or C
B	C or G or T
D	A or G or T
H	A or C or T
V	A or C or G
N	any base

imput:
sequence (16S rRNA gene sequence)

output:
unspecificNucleotides (frequency of uncspecific nucleotides)
[Ns , Rs , Ys , Ws , Ss , Ms , Ks , Hs , Bs , Vs , Ds]

sumOfUnspNucleotides
= sum(unspecificNucleotides)

%}
%global vars

%%% unspecific nucleotides %%%
unspecificNucleotides = zeros(11,1);

%numberOfMatches = 0;

% N (any)
[matchIndex] = regexpi(sequence,'n','start');
if(isempty(matchIndex))
else
    unspecificNucleotides(1) = length(matchIndex);
end

% R (A,G)
[matchIndex] = regexpi(sequence,'r','start');
if(isempty(matchIndex))
else
    unspecificNucleotides(2) = length(matchIndex);
end

% Y (C,T)
[matchIndex] = regexpi(sequence,'y','start');
if(isempty(matchIndex))
else
    unspecificNucleotides(3) = length(matchIndex);
end

% W (A,T)
[matchIndex] = regexpi(sequence,'w','start');
if(isempty(matchIndex))
else
    unspecificNucleotides(4) = length(matchIndex);
end

% S (G,C)
[matchIndex] = regexpi(sequence,'s','start');
if(isempty(matchIndex))
else
    unspecificNucleotides(5) = length(matchIndex);
end

% M (A,C)
[matchIndex] = regexpi(sequence,'m','start');
if(isempty(matchIndex))
else
    unspecificNucleotides(6) = length(matchIndex);
end

% K (G,T)
[matchIndex] = regexpi(sequence,'k','start');
if(isempty(matchIndex))
else
    unspecificNucleotides(7) = length(matchIndex);
end

% H (A,C,T)
[matchIndex] = regexpi(sequence,'h','start');
if(isempty(matchIndex))
else
    unspecificNucleotides(8) = length(matchIndex);
end

% B (G,C,T)
[matchIndex] = regexpi(sequence,'b','start');
if(isempty(matchIndex))
else
    unspecificNucleotides(9) = length(matchIndex);
end

% V (G,A,C)
[matchIndex] = regexpi(sequence,'v','start');
if(isempty(matchIndex))
else
    unspecificNucleotides(10) = length(matchIndex);
end

% D (G,A,T)
[matchIndex] = regexpi(sequence,'d','start');
if(isempty(matchIndex))
else
    unspecificNucleotides(11) = length(matchIndex);
end


%%% unspecific sequences %%%
sumOfUnspNucleotides = sum(unspecificNucleotides);


